% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik_and_deviance.R
\name{logLik.ipriorMod}
\alias{logLik.ipriorMod}
\alias{deviance.ipriorMod}
\alias{logLik.ipriorKernel}
\alias{deviance.ipriorKernel}
\title{Obtain the log-likelihood and deviance of an I-prior model}
\usage{
\method{logLik}{ipriorMod}(object, theta = NULL, ...)

\method{deviance}{ipriorMod}(object, theta = NULL, ...)

\method{logLik}{ipriorKernel}(object, theta = NULL, ...)

\method{deviance}{ipriorKernel}(object, theta = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{ipriorMod} or \code{ipriorKernel}.}

\item{theta}{(Optional) Evaluates the log-likelihood at \code{theta}.}

\item{...}{Not used.}
}
\description{
This function calculates the log-likelihood value or deviance (twice the
negative log-likelihood) for I-prior models. It works for both
\code{ipriorMod} and \code{ipriorKernel} class objects.
}
\details{
For \code{ipriorKernel} objects, the log-likelihood or deviance is calculated
at the default parameter values: scale parameters and error precision are
equal to one, while hyperparameters of the kernels (e.g. Hurst index,
lengthscale, etc.) are the default values (see \link[=kernel]{here} for
details) or ones that has been specified. For \code{ipriorMod} objects, the
log-likelihood or deviance is calculated at the last obtained value from the
estimation method.

For both types of objects, it is possible to supply parameter values at which
to calculate the log-likelihood/deviance. This makes estimating an I-prior
model more flexible, by first loading the variables into an
\code{ipriorKernel} object, and then using an optimiser such as
\code{\link[stats]{optim}}. Parameters have been transformed so that they can
be optimised unconstrained.
}
\seealso{
\link[=check_theta]{check_theta}.
}
