% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monty.R
\name{monty}
\alias{monty}
\title{# Simulation of the Monty Hall Problem
# Demonstrates that switching is always better than staying with 
# your initial guess
Programme written by Corey Chivers, 2012}
\usage{
monty(strat = "stay", N = 1000, print_games = TRUE)
}
\arguments{
\item{strat}{Strategy to use; possibilities are:
\itemize{  
\item{"stay" }{Do not change the initial door chosen}  
\item{"swap" }{Swap the door chosen initially.}  
\item{"random" }{Randomly decide to stay or swap.}
}}

\item{N}{How many games to play, defaults to 1000.}

\item{print_games}{Logical; whether to print the results of each game.}
}
\value{
No return value, called for side effects. If the supplied parameter 
\code{print_games} is TRUE, then it prints out the result
(Win or Loss) of each of the N simulated games. Finally it reports the 
overall percentage of winning.   
   
####################################################
}
\description{
# Simulation of the Monty Hall Problem
# Demonstrates that switching is always better than staying with 
# your initial guess
Programme written by Corey Chivers, 2012
}
\examples{
# example code
monty("stay")
monty("switch")
monty("random")
}
