% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.r
\name{lbl}
\alias{lbl}
\title{Make a label placeholder object}
\usage{
lbl(...)
}
\arguments{
\item{...}{Either one or two arguments, possibly named .val and .lbl. If a
single unnamed value, represents the label, if 2 unnamed values, the first
is the value and the second is the label.}
}
\value{
A \code{label_placeholder} object, useful in functions like \code{\link{lbl_add}}
}
\description{
Helper to make a placeholder for a label-value pair.
}
\examples{
x <- haven::labelled(
  c(100, 200, 105, 990, 999, 230),
  c(`Unknown` = 990, NIU = 999)
)

lbl_add(x, lbl(100, "$100"), lbl(105, "$105"), lbl(200, "$200"), lbl(230, "$230"))

}
\seealso{
Other lbl_helpers: \code{\link{lbl_add}},
  \code{\link{lbl_clean}}, \code{\link{lbl_collapse}},
  \code{\link{lbl_na_if}}, \code{\link{lbl_relabel}},
  \code{\link{zap_ipums_attributes}}
}
\concept{lbl_helpers}
