% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knownMisCalssProb.R
\name{KnownError}
\alias{KnownError}
\title{Estimation of ATE with Known Error}
\usage{
KnownError(data, indA, indYerror, indX, sensitivity, specificity,
  confidence = 0.95)
}
\arguments{
\item{data}{The dataset to be analyzed in the form of R data frame}

\item{indA}{A column name indicating the treatment variable}

\item{indYerror}{A column name indicating the misclassified outcome variable}

\item{indX}{A vector of column names indicating the covariates included in the treatment model}

\item{sensitivity}{The specified sensitivity between 0 and 1}

\item{specificity}{The specified specificity between 0 and 1}

\item{confidence}{The confidence level between 0 and 1; the default is 0.95 corresponding to a 95 per cent confidence interval}
}
\value{
A list of the estimate of average treatment effect, sandwich standard error and confidence interval
}
\description{
Estimation of average treatment effect with known outcome misclassification probabilities, i.e., known sensitivity and specificity
}
\examples{
#create a dataset with sensitivity=0.95 and specificity=0.85
set.seed(100)
X1=rnorm(2000) 
A=rbinom(2000,1,1/(1+exp(-0.2-X1)))
Y=rbinom(2000,1,1/(1+exp(-0.2-A-X1)))
y1=which(Y==1)
y0=which(Y==0) 
Yast=Y
Yast[y1]=rbinom(length(y1),1,0.95)
Yast[y0]=rbinom(length(y0),1,0.15)
da=data.frame(X1=X1,A=A,Yast=Yast)
head(da)
#apply the correction method with sensitivity=0.95 and specificity=0.85
KnownError(da,"A","Yast","X1",0.95,0.85,0.95)

}
