% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmcChem.R
\docType{class}
\name{SmcChem-class}
\alias{SmcChem-class}
\alias{SmcChem}
\title{SMC chemical generator class}
\description{
SMILES generator with Sequence Monte Calro sampler
}
\section{Fields}{

\describe{
\item{\code{qsprpred}}{QSPRpred object}

\item{\code{engram}}{ENgram object}

\item{\code{m}}{numeric value representing the order of extended N-gram model}

\item{\code{v_ESSth}}{numeric value representing the threshold which resample is done when ESS is less than 100 * v_ESSth}

\item{\code{v_decay}}{numeric value decaying temparature for the target distribution in SMC sampler}
}}

\section{Methods}{

\describe{
\item{\code{get_hiscores(nsmi = 100, exsim = 0.8)}}{get chemical structures with high QSPR score from SmcChem object (same as get_hiscores function) }

\item{\code{get_smiles()}}{get SMILES strings from the SmcChem object (same as get_smiles function) }

\item{\code{initialize(smis = NULL, v_engram = NULL, v_qsprpred = NULL, v_m = NULL,
  temp = 1, ESSth = 0.5, lambda = 0, decay = 0.95, gentype = "ML",
  maxstock = 2000)}}{Initialize the SMC chemical generator with initial SMILES strings smis, ENgram class object v_engram and QSPRpred class object v_qsprpred}

\item{\code{smcexec(niter, nsteps = 5, preorder = 0, nview = 0)}}{modify chemical structures with niter SMC updates}

\item{\code{viewstr(idx)}}{view 2D structures from SMILES string vector with index idx (same as viewstr function) }
}}

\examples{
#sample data
data(qspr.data)
idx <- sample(nrow(qspr.data), 5000)
smis <- paste(qspr.data[idx,1])
y <- qspr.data[idx,c(2,5)]

#learning a pattern of chemical strings
data(trainedSMI)
data(engram_5k)  #same as run => engram <- ENgram$new(trainedSMI, order=10)

#learning QSPR model
data(qsprpred_EG_5k)
#same as run => qsprpred <- QSPRpred$new(smis=smis, y=as.matrix(y), v_fpnames="graph")

#set target range 
qsprpred_EG_5k$ymin <- c(200, 1.5)
qsprpred_EG_5k$ymax <- c(350, 2.5)

#getting chemical strings from the Inverse-QSPR model
smchem <- SmcChem$new(smis = rep("c1ccccc1O", 25), v_qsprpred=qsprpred_EG_5k,
                     v_engram=engram_5k,temp=3)
#-----arguments
#smis: initial SMILES strings in SMC sampler
#v_qsprpred: QSPRpred object 
#v_engram: ENgram object
#v_m: numeric value representing the order of modified N-gram model
#ESSth: numeric resampling threshold at 100 * v_ESSth
#temp: numeric, annealing parameter in SMC sampler
#lambda: numeric 
#decay: numeric, decaying rate for temparature 
#-----arguments
                
smchem$smcexec(niter=5, preorder=0, nview=4)
#if OpenBabel (>= 2.3.1) is installed, you can use reordering for better mixing as 
#smchem$smcexec(niter=100, preorder=0.2, nview=4)
#see http://openbabel.org

#check
smiles <- get_smiles(smchem)
predict(qsprpred_EG_5k, smiles[1:5])

}
