% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{filter.ir}
\alias{filter.ir}
\title{Subset rows in \code{ir} objects using column values}
\source{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
\usage{
filter.ir(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that return a
logical value, and are defined in terms of the variables in \code{.data}.
If multiple expressions are included, they are combined with the \code{&} operator.
Only rows for which all conditions evaluate to \code{TRUE} are kept.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
\code{.data} with filtered rows.
}
\description{
Subset rows in \code{ir} objects using column values
}
\examples{
## filter
dplyr::filter(ir_sample_data, sample_type == "office paper")


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
