% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_bc.R
\name{ir_bc_rubberband}
\alias{ir_bc_rubberband}
\title{Performs baseline correction on infrared spectra using a rubberband algorithm}
\usage{
ir_bc_rubberband(x, return_bl = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{return_bl}{A logical value indicating if for each spectrum the baseline
should be returned instead of the corrected intensity values
(\code{return_bl = TRUE}) or not (\code{return_bl = FALSE}).}
}
\value{
An object of class \code{ir} with the baseline corrected spectra and,
if \code{returnbl = TRUE},  the baselines.
}
\description{
\code{ir_bc_rubberband} performs baseline correction for infrared spectra
using a rubberband algorithm. \code{ir_bc_rubberband} is an extended wrapper
function for \code{\link[hyperSpec:spc-rubberband]{hyperSpec::spc.rubberband()}}.
}
\examples{
x1 <-
   ir::ir_sample_data \%>\%
   ir::ir_bc_rubberband(return_bl = FALSE)

}
\seealso{
\code{\link[=ir_bc]{ir_bc()}}
}
