% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extdata.R
\name{sampled-ndvi-Landsat-LC08-T1-L2.csv}
\alias{sampled-ndvi-Landsat-LC08-T1-L2.csv}
\title{Raw Landsat NDVI data}
\format{
A data.table with 1652 rows and 5 variables:
\itemize{
\item id - individual identifier
\item ndvi - sampled NDVI value
\item mask - mask value, see details below
\item doy - julian day/day of year of sample
\item year - year of sample
}

mask details:

\itemize{
\item 0 - Good data
\item 1 - if QA_PIXEL indicates unwanted pixels OR if QA_RADSAT indicates saturated pixels
\item 2 - if QA_PIXEL indicates unwanted pixels AND if QA_RADSAT indicates saturated pixels
}
}
\description{
A CSV containing NDVI samples for seven points over ten years (2005-2010).
Data extracted using Earth Engine with the example script provided by the
\code{use_example_ee_script()} function with sensor set to 'Landsat'.
}
\details{
Note: these are the same locations as in the example 'MODIS' data.
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file('extdata', 'sampled-ndvi-Landsat-LC08-T1-L2.csv', package = 'irg'))
}
