% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim.R
\name{cat_sim_fast}
\alias{cat_sim_fast}
\title{Computerized Adaptive Test (CAT) Simulation (Parallel Computing)}
\usage{
cat_sim_fast(true_ability, cd, verbose = -1, n_cores = NULL)
}
\arguments{
\item{true_ability}{True ability vector to generate item responses.}

\item{cd}{A \code{cat_design} object that is created by function
\code{create_cat_design}.}

\item{verbose}{This is an integer that will print the stage of the test.
For example, if the value verbose = 10, a message will be printed at
each 10th iteration of the cat_simulation. Default value is \code{-1},
where no message will be printed. If the value is \code{0}, only the
start time and end time of the simulation will be printed.}

\item{n_cores}{an integer specifying the number of cores to be used.
The value should be 1 or larger. The default is \code{NULL} where
the maximum number of cores of the processor will be used.}
}
\value{
If the length of \code{true_ability} vector is one a
  \code{"cat_output"} class output will be returned.
  This is a list containing following elements:
  \describe{
    \item{true_ability}{True ability (theta) value to generate item
      responses.}
    \item{est_history}{A list where each element represent a step of the
      CAT test. It has following elements:
      \describe{
        \item{est_before}{The estimated ability before the administration
          of the item. }
        \item{se_before}{The standard error of the estimated ability before
          the administration of the item. }
        \item{testlet}{\code{TRUE} if the item belongs to a testlet.}
        \item{item}{\code{\link{Item-class}} object that is administered at
          this step.}
        \item{resp}{The simulated response of the simulee for the item
          administered at this step using simulee's \code{true_ability}
          value.}
        \item{est_after}{The estimated ability after the administration
          of the item.}
        \item{se_after}{The standard error of the estimated ability after
          the administration of the item. }
       }
    }
  }

  If the length of the \code{true_ability} is more than 1, a list of
  \code{cat_output} objects will be returned for each value of
  \code{true_ability}.
}
\description{
\code{cat_sim_fast} function simulates computerized adaptive test (CAT) for
one or many simulees. This function uses parallel computing, so, for large
number of simulees, it might be significantly faster than
\code{\link{cat_sim}} function.
}
\examples{
cd <- create_cat_design(ip = generate_ip(n = 30),
                        termination_rule = c('max_item'),
                        termination_par = list(max_item = 7))
cat_sim_fast(true_ability = rnorm(1), cd = cd, n_cores = 1)

cat_sim_fast(true_ability = rnorm(2), cd = cd, n_cores = 1)

}
\seealso{
\code{\link{create_cat_design}}
}
\author{
Emre Gonulates
}
