% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-class.R
\docType{class}
\name{Item-class}
\alias{Item-class}
\title{An S4 class to represent an Item}
\description{
\code{Item} is a class to represent an item. An object in Item class should
have a \code{model} name and \code{parameters}.

The model that item \code{parameters} represents. Currently,
  following models are available:
    \describe{
      \item{\code{"Rasch"}}{
        Rasch Model.

        Required parameters:

        \describe{
          \item{\code{"b"}}{Item difficulty parameter.}
          }

        Probability of correct response at ability estimate \eqn{\theta}:

        \deqn{P(\theta) = \frac{e^{(\theta - b)}}{1+e^{(\theta - b)}}}

        Model family: Unidimensional Item Response Theory (UIRT) Models
        }
      \item{\code{"1PL"}}{
        Unidimensional One-Parameter Logistic Model.

        Required parameters:

        \describe{
          \item{\code{"b"}}{Item difficulty parameter.}
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of correct response at ability estimate \eqn{\theta}:

        \deqn{P(\theta) = \frac{e^{D(\theta - b)}}{1+e^{D(\theta - b)}}}

        Model family: Unidimensional Item Response Theory (UIRT) Models
        }
      \item{\code{"2PL"}}{
        Unidimensional Two-Parameter Logistic Model.

        Required parameters:

        \describe{
          \item{\code{"a"}}{Item discrimination parameter.}
          \item{\code{"b"}}{Item difficulty parameter.}
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of correct response at ability estimate \eqn{\theta}:

        \deqn{P(\theta) = \frac{e^{Da(\theta - b)}}{1+e^{Da(\theta - b)}}}

        Model family: Unidimensional Item Response Theory (UIRT) Models
        }
      \item{\code{"3PL"}}{
        Unidimensional Three-Parameter Logistic Model.

        Required parameters:

        \describe{
          \item{\code{"a"}}{Item discrimination parameter.}
          \item{\code{"b"}}{Item difficulty parameter.}
          \item{\code{"c"}}{Pseudo-guessing parameter (lower asymptote).}
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of correct response at ability estimate \eqn{\theta}:

        \deqn{P(\theta) = c + (1-c) \frac{e^{Da(\theta - b)}}{1+e^{Da(\theta - b)}}}

        Model family: Unidimensional Item Response Theory (UIRT) Models
        }
      \item{\code{"4PL"}}{
        Unidimensional Four-Parameter Logistic Model.

        Required parameters:

        \describe{
          \item{\code{"a"}}{Item discrimination parameter.}
          \item{\code{"b"}}{Item difficulty parameter.}
          \item{\code{"c"}}{Pseudo-guessing parameter (lower asymptote).}
          \item{\code{"d"}}{Upper asymptote parameter.}
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of correct response at ability estimate \eqn{\theta}:

        \deqn{P(\theta) = c + (d-c) \frac{e^{Da(\theta - b)}}{1+e^{Da(\theta - b)}}}

        Model family: Unidimensional Item Response Theory (UIRT) Models
        }
      \item{\code{"GRM"}}{
        Graded Response Model

        Required parameters:

        \describe{
          \item{\code{"a"}}{Item discrimination parameter.}
          \item{\code{"b"}}{Item threshold parameters (a vector of values).
            Each value refers to the ability level for which the probability
            of responding at or above that category is equal to 0.5. }
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of scoring at or above the category \eqn{k}:

        \deqn{P^*_k(\theta) = \frac{e^{Da(\theta - b_k)}}{1+e^{Da(\theta - b_k)}}}

        Probability of responding at category \eqn{k} where the possible
        scores are \eqn{0, \ldots, m}:

        \deqn{P_0(\theta) = 1 - P^*_1(\theta)}
        \deqn{P_1(\theta) = P^*_1(\theta) - P^*_2(\theta)}
        \deqn{\cdots}
        \deqn{P_k(\theta) = P^*_{k}(\theta) - P^*_{k+1}(\theta)}
        \deqn{\cdots}
        \deqn{P_m(\theta) = P^*_{m}(\theta)}

        Model family: Polytomous Item Response Theory (PIRT) Models
        }
      \item{\code{"GPCM"}}{
        Generalized Partial Credit Model

        Required parameters:

        \describe{
          \item{\code{"a"}}{Item discrimination parameter.}
          \item{\code{"b"}}{Item step difficulty parameters (a vector of
            values).}
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of scoring at category \eqn{k}:

        \deqn{P_k(\theta) = \frac{exp[\sum_{v = 0}^{k} Da(\theta - b_v)]}
          {\sum_{c = 0}^{m-1}exp[\sum_{v = 0}^{c}Da(\theta - b_v)]}}

        Model family: Polytomous Item Response Theory (PIRT) Models
        }
      \item{\code{"PCM"}}{
        Partial Credit Model (Masters, 1982)

        Required parameters:

        \describe{
          \item{\code{"b"}}{Item step difficulty parameters (a vector of
            values).}
          }

        Probability of scoring at category \eqn{k}:

        \deqn{P_k(\theta) = \frac{exp[\sum_{v = 0}^{k} (\theta - b_v)]}{\sum_{c = 0}^{m-1}exp[\sum_{v = 0}^{c}(\theta - b_v)]}}

        Model family: Polytomous Item Response Theory (PIRT) Models
        }
      \item{\code{"GPCM2"}}{
        An alternative parametrization of Generalized Partial Credit Model
        \code{"GPCM"} where \eqn{b_k = b - d_k}. See Muraki (1997),
        Equation 15 on page 164.

        Required parameters:

        \describe{
          \item{\code{"a"}}{Item discrimination parameter.}
          \item{\code{"b"}}{Location parameter.}
          \item{\code{"d"}}{A vector of threshold parameters.}
          \item{\code{"D"}}{Scaling constant. Default value is \code{1}.}
          }

        Probability of scoring at category \eqn{k}:

        \deqn{P_k(\theta) = \frac{exp[\sum_{v = 0}^{k} Da(\theta - b + d_v)]}{\sum_{c = 0}^{m-1}exp[\sum_{v = 0}^{c}Da(\theta - b + d_v)]}}

        Model family: Polytomous Item Response Theory (PIRT) Models
        }
    }

  A model must be specified for the construction of an \code{Item} object.
}
\section{Slots}{

\describe{
\item{\code{item_id}}{Item ID. Default value is \code{NULL}.}

\item{\code{content}}{Content information for the Item object.}

\item{\code{misc}}{This slot is a list where one can put any information about
the Item object. For example, one can enter the ID's of the enemies of the current
Item as \code{misc = list(enemies = c("i1", i2))}. Or, one can enter
Sympson-Hetter exposure control parameter K:
\code{misc = list(sympson_hetter_k = .75)}.}
}}

\references{
Masters, G. N. (1982). A Rasch model for partial credit scoring.
  \emph{Psychometrika}, 47, 149–174.

  Muraki, E. (1992). A generalized partial credit model:
  Application of an EM algorithm. \emph{Applied Psychological Measurement},
  16, 159–176.
}
\author{
Emre Gonulates
}
