% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_max_possible_total_score}
\alias{get_max_possible_total_score}
\title{Calculate the maximum score of a set of items}
\usage{
get_max_possible_total_score(ip, resp = NULL)
}
\arguments{
\item{ip}{An \code{\link{Itempool-class}} object.}

\item{resp}{(optional) A response vector or a response matrix. The contents
are not important. The function only checks whether an element is missing
or not. If an element is missing, then that item will not count towards
the maximum possible score. If the maximum score of all items are needed,
set \code{resp = NULL}.}
}
\value{
A vector of numbers showing the maximum possible scores.
}
\description{
Calculate the maximum score of a set of items
}
\examples{
ip <- generate_ip(n = 10)
get_max_possible_total_score(ip)
# A mixture of dichotomous and polytomous items
ip <- generate_ip(model = c("3PL", "GRM", "3PL", "GRM", "GRM"),
                  n_categories = c(2, 5, 2, 4, 6))
# 1 + 4 + 1 + 3 + 5 = 14
get_max_possible_total_score(ip)
}
\author{
Emre Gonulates
}
