% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distractor_icc.R
\name{plot_distractor_icc}
\alias{plot_distractor_icc}
\title{Plot Empirical Item or Test characteristic curve}
\usage{
plot_distractor_icc(
  raw_resp,
  item,
  key = NULL,
  ip = NULL,
  criterion = NULL,
  bins = 10,
  x_axis_scale = NULL,
  add_icc = FALSE,
  title = "",
  n_dodge = 1,
  x_lim = NULL,
  base_r_graph = FALSE,
  suppress_plot = FALSE,
  ...
)
}
\arguments{
\item{raw_resp}{Raw response matrix.}

\item{item}{The column number, column name or the 'ID' of the  the item that
should be plotted.}

\item{key}{A vector of answer key. If \code{key = NULL}, the function will
check whether the item pool has keys by checking \code{ip$key} and raise
an error if \code{ip$key} is not valid.}

\item{ip}{An \code{\link{Itempool-class}} object that is needed for some
plots. If \code{ip} provided and \code{criterion} is not provided, then
ability will be estimated using EAP method with prior mean 0 and prior
standard deviation of 1. This is a slower method depending on the size of
the data. Also, the key for items can be provided via \code{ip$key}.}

\item{criterion}{A vector of examinee abilities. If \code{criterion} values
provided the bins are formed using them instead of sum scores.}

\item{bins}{An integer larger than 2 representing of ability groups examinees
should be grouped into. The default is \code{10}. The maximum value of
\code{bins +  1} is the number of possible total scores.}

\item{x_axis_scale}{Set the scale of the x-axis. The default value is
\code{NULL}. For if sum score is used scale will be defaulted to
\code{"percent"}, Otherwise if valid \code{criterion} or \code{ip}
arguments provided  the scale defaults to \code{"criterion"}.
\describe{
  \item{\strong{\code{"percent"}}}{Percent interval.}
  \item{\strong{\code{"number"}}}{Numbers between 1 and \code{bins}.}
  \item{\strong{\code{"criterion"}}}{Criterion values equally divided into
  bins. the middle value of the bin is shown in the x-axis. For example, if
  \code{bins = 10}, the first tick of the x-axis will be the mean of
  minimum criterion value and tenth percentile criterion value.}
  }}

\item{add_icc}{If \code{TRUE}, adds item characteristic curve to the plot.
Only available if a valid item pool object (\code{ip}) is provided and
\code{x_axis_scale = "criterion"}. The default value is \code{FALSE}.}

\item{title}{Title of the plot. If the value is \code{NULL}, the plot title
will be suppressed.}

\item{n_dodge}{The number of lines the x-axis tick labels should be written
to. This is especially useful if the x-axis tick labels overlap with each
other. The default value is \code{1}, which means all of the labels are
written on the same line.}

\item{x_lim}{The limits of x axis in the form \code{c(-4, 4)}. Only available
when \code{x_axis_scale = "criterion"}. The default value is \code{NULL}
where the limits will be the minimum and maximum 'criterion' values.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the proportion of examinees in each bin respond to each distractor or
returns the plot object.
}
\description{
\code{plot_empirical_icc} plots empirical item or test characteristic curve.
}
\examples{
n_item <- 10 # sample(8:12, 1)
n_theta <- 10000 # sample(100:200, 1)
raw_resp <- matrix(sample(LETTERS[1:4], n_item * n_theta, replace = TRUE),
                   nrow = n_theta, ncol = n_item,
                   dimnames = list(paste0("Examinee-", 1:n_theta),
                                   paste0("Item_", 1:n_item)))
key <- sample(LETTERS[1:4], n_item, replace = TRUE)
plot_distractor_icc(raw_resp, 3, key)
# Change the number of bins
plot_distractor_icc(raw_resp, 3, key, bins = 15)

}
\author{
Emre Gonulates
}
