% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_pca.R
\docType{methods}
\name{ternary_pca}
\alias{ternary_pca}
\alias{ternary_pca-method}
\alias{ternary_pca,numeric,numeric,numeric-method}
\alias{ternary_pca,ANY,missing,missing-method}
\title{Principal Component Analysis}
\usage{
ternary_pca(x, y, z, ...)

\S4method{ternary_pca}{numeric,numeric,numeric}(x, y, z, axis = 1, ...)

\S4method{ternary_pca}{ANY,missing,missing}(x, axis = 1, ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[graphics:lines]{graphics::lines()}}.}

\item{axis}{An \code{\link{integer}} specifying the dimension to be plotted.}
}
\value{
\code{ternary_pca()} is called it for its side-effects.
}
\description{
Computes and draws principal component.
}
\examples{
## PCA
## Data from Aitchison 1986
ternary_plot(lava, panel.first = ternary_grid())
ternary_pca(lava, axis = 1, col = "red", lty = 2)
}
\seealso{
Other statistics: 
\code{\link{ternary_contour}()},
\code{\link{ternary_density}()},
\code{\link{ternary_ellipse}()},
\code{\link{ternary_hull}()},
\code{\link{ternary_mean}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
