% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{add.isolation.tree}
\alias{add.isolation.tree}
\title{Add additional (single) tree to isolation forest model}
\usage{
add.isolation.tree(model, df, sample_weights = NULL, column_weights = NULL)
}
\arguments{
\item{model}{An Isolation Forest object as returned by \link{isolation.forest}, to which an additional tree will be added.

This object will be modified in-place.}

\item{df}{A `data.frame`, `data.table`, `tibble`, `matrix`, or sparse matrix (from package `Matrix` or `SparseM`, CSC format)
to which to fit the new tree.}

\item{sample_weights}{Sample observation weights for each row of 'X', with higher weights indicating
distribution density (i.e. if the weight is two, it has the same effect of including the same data
point twice). If not `NULL`, model must have been built with `weights_as_sample_prob` = `FALSE`.}

\item{column_weights}{Sampling weights for each column in `df`. Ignored when picking columns by deterministic criterion.
If passing `NULL`, each column will have a uniform weight. Cannot be used when weighting by kurtosis.}
}
\value{
The same `model` object now modified, as invisible.
}
\description{
Adds a single tree fit to the full (non-subsampled) data passed here. Must
have the same columns as previously-fitted data.
}
\details{
Be aware that, if something goes wrong in the process (such as running out of RAM or
receiving an interrupt signal), the `model` object that was passed here might be rendered unusable.

For safety purposes, the model object can be deep copied (including the underlying C++ object)
through function \link{deepcopy.isotree} before undergoing an in-place modification like this.
}
\seealso{
\link{isolation.forest} \link{unpack.isolation.forest}
}
