% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issueReport.R
\name{issueReport}
\alias{issueReport}
\title{Generate a PDF report from a GitHub issue thread.}
\usage{
issueReport(issueNumber = 1, outputFile = NULL, outputDir = NULL,
  githubUsername = "xxxxxxxxxxxxxxxxxxxx",
  githubToken = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
  githubUrl = "https://api.github.com/",
  githubRepo = "mkirch/issueReporter", setTitle = "Issue Notes",
  setAuthor = "Julius Caesar", includeTitle = TRUE, includeBody = TRUE,
  test = FALSE)
}
\arguments{
\item{issueNumber}{Integer GitHub issue number.}

\item{outputFile}{String containing file name for R Markdown pdf output,
\code{report.Rmd} if NULL.}

\item{outputDir}{String containing directory address for R markdown output,
working directory if NULL.}

\item{githubUsername}{String of GitHub username to authenticate with.}

\item{githubToken}{String containing GitHub personal access token, as
generated from the settings area in your GitHub account.}

\item{githubUrl}{String containing the API URL for GitHub. If using a GitHub
Enterprise account, use http(s)://hostname/api/v3/ instead of default. Please
make sure to append a \code{`/`}.}

\item{githubRepo}{String of format \code{user/repo} specifying the GH repo.}

\item{setTitle}{String containing report title.}

\item{setAuthor}{String containing report author.}

\item{includeTitle}{Bool where TRUE includes the title, and FALSE excludes.}

\item{includeBody}{Bool where TRUE includes the original issue, and FALSE
includes only the issue comments.}

\item{test}{Bool If we are using this in test mode.}
}
\description{
For a given GitHub issue, extracts all issue comments and generates a PDF
report of each user's contributions to the thread. View /inst/examples/
to see a quick sample and output besides the usage below.
}
