% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot_utility_functions.R
\name{fadeRug}
\alias{fadeRug}
\title{Utility function.}
\usage{
fadeRug(x, y, n.grid = 30, gradual = FALSE, max.alpha = 0.75,
  col = "white")
}
\arguments{
\item{x}{Observations on x-axis.}

\item{y}{Observations on y-axis.}

\item{n.grid}{Resolution of Rug. Defaults to 30,
which means that the x- and y-axis are divided in 30 bins.}

\item{gradual}{Logical: whether or not to use the number of
observations in an area, i.e., more transparent equals more
observations. Default is FALSE, which means that the function only
distinguishes between observations in a certain region or not,
regardless how many observations.}

\item{max.alpha}{Maximum of transparency, number between 0 (completely
transparent) and 1 (non-transparent). Defaults to .75.}

\item{col}{Color value. Defaults to "white".}
}
\value{
Plots a shaded image over the contour plot or image.
}
\description{
Add a transparency Rug to a contour plot or image.
}
\section{Warning}{

On Linux \code{\link{x11}} devices may not support transparency.
In that case, a solution might be to write the plots immediately to a file
using functions such as \code{\link{pdf}}, or \code{\link{png}}.
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[graphics]{rug}}, \code{\link[graphics]{contour}},
\code{\link[graphics]{image}}

Other Utility functions for plotting: \code{\link{addInterval}};
  \code{\link{alphaPalette}}; \code{\link{alpha}};
  \code{\link{dotplot_error}}; \code{\link{emptyPlot}};
  \code{\link{errorBars}}; \code{\link{fill_area}};
  \code{\link{find_difference}}; \code{\link{getCoords}};
  \code{\link{gradientLegend}}; \code{\link{horiz_error}};
  \code{\link{plot_error}}
}

