% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_random}
\alias{get_random}
\title{Get coefficients for the random intercepts and random slopes.}
\usage{
get_random(model, cond = NULL, print.summary = getOption("itsadug_print"))
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{cond}{A named list of the values to restrict the estimates for the
random predictor terms. When NULL (default) all levels are returned.
Only relevant for complex interactions, which involve more than two
dimensions.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor.
Default set to the print info messages option
(see \code{\link{infoMessages}}).}
}
\value{
The coefficients of the random intercepts
and slopes.
}
\description{
Get coefficients for the random intercepts and random slopes.
}
\examples{
data(simdat)

\dontrun{
# Condition as factor, to have a random intercept
# for illustration purposes:
simdat$Condition <- as.factor(simdat$Condition)

# Model with random effect and interactions:
m2 <- bam(Y ~ s(Time) + s(Trial)
+ ti(Time, Trial)
+ s(Condition, bs='re')
+ s(Time, Subject, bs='re'),
data=simdat)

# extract all random effects combined:
newd <- get_random(m2)
head(newd)

# extract coefficients for the random intercept for Condition:
# Make bar plot:
barplot(newd[[1]])
abline(h=0)

# or select:
get_random(m2, cond=list(Condition=c('2','3')))
}
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model predictions: \code{\link{get_coefs}};
  \code{\link{get_difference}};
  \code{\link{get_modelterm}};
  \code{\link{get_predictions}};
  \code{\link{inspect_random}}; \code{\link{plotsurface}}
}

