% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_image}
\alias{plot_image}
\title{Add images to plots.}
\usage{
plot_image(img, type = "image", col = NULL, show.axes = FALSE,
  xrange = c(0, 1), yrange = c(0, 1), fill.plotregion = FALSE,
  replace.colors = NULL, add = FALSE, ...)
}
\arguments{
\item{img}{Matrix or image object (list with 'image', a matrix, and 'col', 
a vector with color values), or a string indicating the filename of an 
image to read.}

\item{type}{String, 'image' (default), 'png', 'jpeg', 'gif'}

\item{col}{Vector with colors.}

\item{show.axes}{Logical: whether or not to plot the axes.}

\item{xrange}{Two-value vector providing the xleft and xright coordinate 
values of the picture. Default set to c(0,1).}

\item{yrange}{Two-value vector providing the ybottom and ytop coordinate 
values of the picture. Default set to c(0,1).}

\item{fill.plotregion}{Logical: whether or not to fill the complete plot 
region. Defaults to FALSE.}

\item{replace.colors}{Named list for replacing colors. The names are the 
colors (in hexadecimal values), or regular expressions matching colors. The 
values are the replacements.}

\item{add}{Logical: whether or not to add the plot to the current plot.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\value{
Optionally returns
}
\description{
Add images to plots.
}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alphaPalette}},
  \code{\link{alpha}}, \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fadeRug}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plotsurface}},
  \code{\link{rug_model}}
}

