% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{plot_diff2}
\alias{plot_diff2}
\alias{plotDiff2D}
\title{Plot difference surface based on model predictions.}
\usage{
plot_diff2(
  model,
  view,
  comp,
  cond = NULL,
  color = "terrain",
  nCol = 100,
  col = NULL,
  add.color.legend = TRUE,
  se = 1.96,
  sim.ci = FALSE,
  show.diff = FALSE,
  col.diff = 1,
  alpha.diff = 0.5,
  n.grid = 30,
  nlevels = 10,
  zlim = NULL,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  rm.ranef = TRUE,
  transform.view = NULL,
  hide.label = FALSE,
  dec = NULL,
  f = 1.96,
  print.summary = getOption("itsadug_print"),
  ...
)
}
\arguments{
\item{model}{A GAMM model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{view}{Name of continuous predictors that should be plotted on the x-
and y-axes. Vector of two values.}

\item{comp}{Named list with the grouping predictor (categorical variable)
and the 2 levels to calculate the difference for.}

\item{cond}{Named list of the values to use for the other predictor terms 
(not in view).}

\item{color}{The color scheme to use for plots. One of 'topo', 'heat', 
'cm', 'terrain', 'gray' or 'bw'. Alternatively a vector with some colors 
can be provided for a custom color palette.}

\item{nCol}{Range of colors of background of contour plot.}

\item{col}{Line color.}

\item{add.color.legend}{Logical: whether or not to add a color legend. 
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{se}{If less than or equal to zero then only the predicted surface is 
plotted, but if greater than zero, then the predicted values plus 
confidence intervals are plotted. 
The value of \code{se} will be multiplied with 
the standard error (i.e., 1.96 results in 95\%CI and 2.58). 
Default is set to 1.96 (95\%CI).}

\item{sim.ci}{Logical: Using simultaneous confidence intervals or not 
(default set to FALSE). The implementation of simultaneous CIs follows 
Gavin Simpson's blog of December 15, 2016: 
\url{http://www.fromthebottomoftheheap.net/2016/12/15/simultaneous-interval-revisited/}. 
This interval is calculated from simulations based. 
Please specify a seed (e.g., \code{set.seed(123)}) for reproducable results. 
Note: in contrast with Gavin Simpson's code, here the Bayesian posterior 
covariance matrix of the parameters is uncertainty corrected 
(\code{unconditional=TRUE}) to reflect the uncertainty on the estimation of 
smoothness parameters.}

\item{show.diff}{Logical: whether or not to indicate the regions that 
are significantly different from zero. Note that these regions are just 
an indication and dependent on the value of \code{n.grid}. 
Defaults to FALSE.}

\item{col.diff}{Color to shade the nonsignificant areas.}

\item{alpha.diff}{Level of transparency to mark the nonsignificant areas.}

\item{n.grid}{Resolution.}

\item{nlevels}{Levels of contour lines.}

\item{zlim}{A two item array giving the lower and upper limits for the z-
axis scale. NULL to choose automatically.}

\item{xlim}{A two item array giving the lower and upper limits for the x-
axis scale. NULL to choose automatically.}

\item{ylim}{A two item array giving the lower and upper limits for the y-
axis scale. NULL to choose automatically.}

\item{main}{Title of plot.}

\item{xlab}{Label x-axis.}

\item{ylab}{Label y-axis.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is TRUE. Alternatively a string (or vector of strings) with the 
name of the random effect(s) to remove.}

\item{transform.view}{List with two functions for transforming 
the values on the x- and y-axis respectively. If one of the axes 
need to be transformed, set the other to NULL (no transformation). 
(See \code{\link{fvisgam}} for more info.)}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., 'difference'). Default is FALSE.}

\item{dec}{Numeric: number of decimals for rounding the color legend. 
When NULL (default), no rounding. If -1 (default), automatically determined. 
Note: if value = -1 (default), rounding will be applied also when 
\code{zlim} is provided.}

\item{f}{Scaling factor to determine the CI from the se, for marking the 
difference with 0. Only applies when \code{se} is smaller or equal to zero 
and \code{show.diff} is set to TRUE.}

\item{print.summary}{Logical: whether or not to print a summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{...}{Optional arguments for \code{\link[plotfunctions]{plotsurface}}.}
}
\value{
If the result is not being plotted, a list is 
returned with the estimated difference (\code{est}) and the standard error 
over the estimate (\code{se.est}) and the x-values (\code{x}) is returned.
}
\description{
Plot difference surface based on model predictions.
}
\section{Warning}{

When the argument \code{show.diff} is set to TRUE a shading area indicates 
where the confidence intervals include zero. Or, in other words, the areas 
that are not significantly different from zero. Be careful with the 
interpretation, however, as the precise shape of the surface is dependent 
on model constraints such as the value of \code{\link[mgcv]{choose.k}} and the 
smooth function used, and the size of the confidence intervals are 
dependent on the model fit and model characteristics 
(see \code{vignette('acf', package='itsadug')}). In addition, the value of 
\code{n.grid} determines the precision of the plot.
}

\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group),
    data=simdat)
plot_diff2(m1, view=c('Time', 'Trial'), 
    comp=list(Group=c('Children', 'Adults')))
}
}
\seealso{
Other Testing for significance: 
\code{\link{compareML}()},
\code{\link{plot_diff}()},
\code{\link{report_stats}()},
\code{\link{wald_gam}()}
}
\author{
Martijn Wieling, reimplemented by Jacolien van Rij
}
\concept{Testing for significance}
