% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{estimate_llh}
\alias{estimate_llh}
\title{Estimate the Log-Likelihood for a given parameter combination}
\usage{
estimate_llh(model, data, parameter, sim = 100, cores = 1,
  normalized = FALSE, sim_data = NULL)
}
\arguments{
\item{model}{The model used for the estimation. 
See \code{\link{create_jaatha_model}}.}

\item{data}{The data used for the estimation.
See \code{\link{create_jaatha_data}}.}

\item{parameter}{The parameter combination for which the loglikelihood
will be estimated.}

\item{sim}{The number of simulations that will be used for averaging the
expectation values of the summary statistics.}

\item{cores}{The number of CPU cores that will be used for the simulations.
The relies on the \pkg{parallel} package, and consequently only one
core is supported on Windows.}

\item{normalized}{For internal use. Indicates whether the parameter
combination is normalized to [0, 1]-scale, or on its natural
scale.}

\item{sim_data}{For internal use. Use existing simulations.}
}
\description{
This function estimates the Log-likelihood value for a given
parameter combination. It conducts a number of simulations for
the parameter combination, averages the summary statistics to
esimate their expected values, and uses them to calculate the
likelihood. For a resonable number of simulation, this is more
precise than the glm fitting used in the main algorithm.
}

