% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaw.R
\name{sigmaw}
\alias{sigmaw}
\title{Weierstrass sigma function}
\usage{
sigmaw(z, g = NULL, omega = NULL)
}
\arguments{
\item{z}{complex number}

\item{g}{the elliptic invariants, a vector of two complex numbers; they are 
related to the half-periods (\code{omega}) and only one of \code{g} 
and \code{omega} must be given}

\item{omega}{the half-periods, a vector of two complex numbers; they are 
related to the elliptic invariants (\code{g}) and only one of \code{g} 
and \code{omega} must be given}
}
\value{
A complex number.
}
\description{
Evaluation of the Weierstrass sigma function.
}
\examples{
sigmaw(1, g = c(12, -8))
# should be equal to:
sin(1i*sqrt(3))/(1i*sqrt(3)) / sqrt(exp(1))
}
