% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{plotRhats}
\alias{plotRhats}
\title{Plotting all Rhat values}
\usage{
plotRhats(
  x,
  p = NULL,
  n.eff = FALSE,
  fence = NULL,
  plotsequence = FALSE,
  splitarr = FALSE,
  margin = NULL,
  ...
)
}
\arguments{
\item{x}{Output object returned from \code{jagsUI}}

\item{p}{Optional vector of parameters to subset}

\item{n.eff}{Optionally, whether to plot \code{n.eff} instead of \code{Rhat}.  Defaults to \code{FALSE}.}

\item{fence}{Value of horizontal lines to overlay as reference.  Accepting the default value (\code{NULL}) will give \code{fence} values
of 1.1 (a commonly used value) and 1.01 for Rhat, or 100 and 500 for \code{n.eff.}}

\item{plotsequence}{Whether to plot parameter vectors (or matrices) in a sequence, running left to right, which may
be useful for time series models, etc.  If the default (\code{FALSE}) is used, a vertical cluster will be plotted
for each parameter, resulting in a simpler plot if there are many parameters.  Note that the \code{Rhat} values will still be
plotted in sequence if the default (\code{FALSE}) is used.}

\item{splitarr}{Whether to split 2+ dimensional parameter arrays by a given dimension, rather than plotting the full
array in one vertical cluster or continuous sequence.  This may be recommended in the case of large arrays.  Defaults to \code{FALSE}.}

\item{margin}{If \verb{splitarr=} is set to \code{TRUE}, which array margin to split by.  In the case of a 2-dimensional array, setting
\code{margin=2} will separate the array by column.  If the default (\code{NULL}) is accepted, the function will split by the smallest dimension,
therefore splitting into the fewest groups.}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Plotting all values of \code{Rhat} (or alternately \code{n.eff}) from an output object returned by \code{jagsUI}, or perhaps a subset of parameters.
This function is intended as a quick graphical check of which parameters have adequately converged.

\code{Rhat} (Gelman-Rubin Convergence Diagnostic, or Potential Scale Reduction Factor)
is calculated within 'JAGS', and is
commonly used as a measure of convergence for a given parameter node.  Values close
to 1 are seen as evidence of adequate convergence.  \code{n.eff} is also calculated within 'JAGS', and may be interpreted as a crude measure of
effective sample size for a given parameter node.
}
\examples{
## plotting everything
plotRhats(SS_out)
str(SS_out$Rhat)  # the associated values

plotRhats(SS_out, n.eff=TRUE)
str(SS_out$n.eff)  # the associated values

## behavior of splitarr and margin are shown
plotRhats(SS_out)
plotRhats(SS_out, splitarr=TRUE)
str(SS_out$Rhat) # the associated values

## plotsequence may be useful in the case of a sequence of values
plotRhats(SS_out, p=c("trend", "cycle_s"), splitarr=TRUE, plotsequence=TRUE)
}
\references{
Gelman, A., & Rubin, D. B. (1992). Inference from Iterative Simulation
Using Multiple Sequences. \emph{Statistical Science, 7}(4), 457–472. http://www.jstor.org/stable/2246093
}
\seealso{
\link{traceworstRhat}, \link{check_Rhat}
}
\author{
Matt Tyers
}
