% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_jags_df.R
\name{tar_jags_df}
\alias{tar_jags_df}
\title{Select a strategic piece of \code{R2jags} output.}
\usage{
tar_jags_df(
  fit,
  data,
  output = c("draws", "summary", "dic"),
  variables = NULL,
  summaries = NULL,
  summary_args = NULL
)
}
\arguments{
\item{fit}{\code{R2jags} object.}

\item{data}{A list, the original JAGS dataset.}

\item{output}{Character of length 1 denoting the type of output \code{tibble}
to return: \code{"draws"} for MCMC samples (which could take up a lot of space)
\code{"summary"} for lightweight posterior summary statistics,
and \code{"dic"} for the overall deviance information criterion
and effective number of parameters}

\item{variables}{Character vector of model parameter names.
The output posterior summaries are restricted to these variables.}

\item{summaries}{List of summary functions passed to \code{...} in
\code{posterior::summarize_draws()} through \verb{$summary()}
on the \code{CmdStanFit} object.}

\item{summary_args}{List of summary function arguments passed to
\code{.args} in \code{posterior::summarize_draws()} through \verb{$summary()}
on the \code{CmdStanFit} object.}
}
\value{
A data frame of \code{R2jags} output. Depends on the \code{output} argument.
}
\description{
Not a user-side function. Do not call directly.
Exported for infrastructure reasons only.
}
\keyword{internal}
