% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{groupedAxis}
\alias{groupedAxis}
\title{Draw grouped axis labels}
\usage{
groupedAxis(
  side = 1,
  x,
  group_style = c("partial_grouped", "grouped", "centered"),
  las = 2,
  returnFractions = TRUE,
  nudge = 0.2,
  do_abline = FALSE,
  abline_lty = "solid",
  abline_col = "grey40",
  do_plot = TRUE,
  ...
)
}
\arguments{
\item{side}{\code{integer} indicating the axis side, passed to \code{graphics::axis()}.
1=bottom, 2=left, 3=top, 4=right.}

\item{x}{\code{character} vector of axis labels}

\item{group_style}{\code{character} string indicating the style of label:
\itemize{
\item \code{"partial_grouped"} - uses square bracket to bound 2+ repeated entries,
and single line tick mark for non-repeated entries.
\item \code{"grouped"} - uses square bracket to bound each set of repeated entries
including non-repeated entries.
\item \code{"centered"} - only labels the center of each group of repeated entries
with no bracket bounding the entries.
}}

\item{las}{\code{integer} indicating whether labels should be perpendicular,
see \code{graphics::par("las")}.}

\item{returnFractions}{\code{logical} passed to \code{breaksByVector()} to calculate
label positions. Set \code{returnFractions=FALSE} and all labels will only
appear at integer locations on the axis.}

\item{nudge}{\code{numeric} adjustment for labels away from the plot border.}

\item{do_abline}{\code{logical} indicating whether to draw \code{graphics::abline()} lines
inside the plot to indicate the exact breakpoints between each group
of labels.}

\item{abline_lty}{line type compatible with \code{graphics::par("lty")}, used when
\code{do_abline=TRUE}.}

\item{abline_col}{\code{character} color used when \code{do_abline=TRUE}.}

\item{do_plot}{\code{logical} whether to plot the resulting axis,
as an option to suppress the output and do something else
with the \code{data.frame} of coordinates returned by this function.}

\item{...}{additional arguments are passed to \code{breaksByVector()}, and/or to
\code{graphics::axis()}.}
}
\value{
\code{data.frame} invisibly, which contains the relevant axis
coordinates, labels, and whether the coordinate should
appear with a tick mark.
}
\description{
Draw grouped axis labels given a character vector.
}
\details{
This function extends \code{breaksByVector()} specifically for
axis labels. It is intended where character labels are spaced
at integer steps, and some labels are expected to be repeated.
}
\examples{
withr::with_par(list("mar"=c(4,4,6,6)), {
b <- rep(LETTERS[1:5], c(2,3,5,4,3));
b2 <- c(b[1:2], makeNames(b[3:5]), b[6:16]);
nullPlot(doBoxes=FALSE,
   doUsrBox=TRUE,
   xlim=c(0,18),
   ylim=c(0,18));

groupedAxis(1, b);
groupedAxis(2, b, group_style="grouped");
groupedAxis(2, b, group_style="centered");
groupedAxis(3, b2, do_abline=TRUE);
groupedAxis(4, b2, group_style="grouped");
graphics::mtext(side=1, "group_style='partial_grouped'", line=2, las=0);
graphics::mtext(side=2, "group_style='grouped'", line=2, las=0);
graphics::mtext(side=3, "group_style='partial_grouped'", line=2, las=0);
graphics::mtext(side=4, "group_style='grouped'", line=2, las=0);
})

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
