% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{isColor}
\alias{isColor}
\title{detect valid R color}
\usage{
isColor(x, makeNamesFunc = c, ...)
}
\arguments{
\item{x}{character vector of potential R colors}

\item{makeNamesFunc}{function used to make names for the resulting vector}

\item{...}{additional parameters are ignored}
}
\value{
\code{logical} vector with length(x).
}
\description{
detect valid R color
}
\details{
This function determines whether each element in a vector is a valid R
color, based upon the R color names, valid hex color format, and the
word "transparent" which is valid as an R color.
}
\examples{
isColor(c("red", "blue", "beige", "#99000099", "#aa00ff", "#AAE", "bleh"))

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
