% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{nameVector}
\alias{nameVector}
\title{assign unique names for a vector}
\usage{
nameVector(x, y = NULL, makeNamesFunc = makeNames, ...)
}
\arguments{
\item{x}{\code{character} vector, or \code{data.frame} or equivalent
(matrix, or tibble) with two columns, the second column
is used to name values in the first column.}

\item{y}{\code{character} or NULL, with names. If NULL then x is used.
Note that y is recycled to the length of x, prior to being sent
to the makeNamesFunc.
In fringe cases, y can be a matrix, data.frame, or tibble, in which
case \code{pasteByRow()} will be used to create a character string
to be used for vector names. Note this case is activated only when x
is not a two column matrix, data.frame, or tibble.}

\item{makeNamesFunc}{\code{function} to make names unique, by default
\code{makeNames()} which ensures names are unique.}

\item{...}{passed to \code{makeNamesFunc}, or to
\code{pasteByRow()} if y is a two column data.frame, matrix, or
tibble. Thus, \code{sep} can be defined here as a delimiter between
column values.}
}
\value{
vector with names defined
}
\description{
assign unique names for a vector
}
\details{
This function assigns unique names to a vector, if necessary it runs
\code{\link{makeNames}} to create unique names. It differs from
\code{\link[stats]{setNames}} in that it ensures names are unique,
and when no names are supplied, it uses the vector itself to define
names. It is helpful to run this function inside an \code{\link[base]{lapply}}
function call, which by default maintains names, but does not assign
names if the input data did not already have them.

When used with a data.frame, it is particularly convenient to pull out
a named vector of values. For example, log2 fold changes by gene, where
the gene symbols are the name of the vector.

\code{nameVector(genedata[,c("Gene","log2FC")])}
}
\examples{
# it generally just creates names from the vector values
nameVector(LETTERS[1:5]);

# if values are replicated, the makeNames() function makes them unique
V <- rep(LETTERS[1:5], each=3);
nameVector(V);

# for a two-column data.frame, it creates a named vector using
# the values in the first column, and names in the second column.
df <- data.frame(seq_along(V), V);
df;
nameVector(df);

# Lastly, admittedly a fringe case, it can take a multi-column data.frame
# to generate labels:
nameVector(V, df);

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
