% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-rainbow2.R
\name{rainbow2}
\alias{rainbow2}
\title{Simple rainbow palette replacement}
\usage{
rainbow2(n, s = c(0.9, 0.7, 0.88, 0.55), v = c(0.92, 1, 0.85, 0.94), ...)
}
\arguments{
\item{n}{\code{integer} number of colors requested}

\item{s, v}{\code{numeric} vector of values to recycle as saturation and
vibrance, respectively. The purpose is to improve visual distinction
between adjacent and nearby colors in the color wheel.}

\item{...}{additional arguments are passed to \code{grDevices::rainbow()}:
\itemize{
\item \code{start},\code{end} to control the starting and ending hue \verb{[0,1]},
\item \code{alpha} for alpha opacity, default NULL adds no alpha,
\item \code{rev} to reverse the color order.
}}
}
\value{
\code{character} vector of R colors.
}
\description{
Simple rainbow palette replacement using variable saturation and vibrance
}
\examples{
showColors(list(
   `rainbow(24)`=grDevices::rainbow(24),
   `rainbow2(24)`=rainbow2(24),
   `rainbow2(24, rev=TRUE)`=rainbow2(24, rev=TRUE),
   `rainbow2(24, start=0.5, end=0.499)`=rainbow2(24,
      start=0.5, end=0.5-1e-5),
   `rainbow2(24, rev=TRUE,\nstart=0.5, end=0.499)`=rainbow2(24,
      rev=TRUE, start=0.5, end=0.5-1e-5)))

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
