% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-showcolors.R
\name{showColors}
\alias{showColors}
\title{Show colors from a vector or list}
\usage{
showColors(
  x,
  labelCells = NULL,
  transpose = FALSE,
  srtCellnote = NULL,
  adjustMargins = TRUE,
  makeUnique = FALSE,
  doPlot = TRUE,
  ...
)
}
\arguments{
\item{x}{one of these input types:
\itemize{
\item \code{character} vector of colors
\item \code{function} to produce colors, for example \code{circlize::colorRamp2()}
\item \code{list} with any combination of \code{character} or \code{function}
}}

\item{labelCells}{\code{logical} whether to label colors atop the color itself.
If NULL (default) it will only display labels with 40 or fewer items
on either axis.}

\item{transpose}{\code{logical} whether to transpose the colors to display
top-to-bottom, instead of left-to-right.}

\item{srtCellnote}{\code{numeric} angle to rotate text when
\code{labelCells=TRUE}. When set to NULL, labels are vertical
srtCellnote=90 when \code{transpose=FALSE} and horizontal
srtCellnote=0 when \code{transpose=TRUE}.}

\item{adjustMargins}{\code{logical} indicating whether to call
\code{adjustAxisLabelMargins()} to adjust the x- and y-axis
label margins to accomodate the label size.
\itemize{
\item Note when an axis is hidden by using \code{xaxt="n"} or \code{xaxt="n"},
the respective margin will not be adjusted.
\item The arguments in \code{...} take precedence over \code{graphics::par()},
when deciding whether to adjust margins. However if \code{xaxt="s"} and
\code{graphics::par("xaxt"="n")} the margin will be adjusted but not
displayed.
In this way the axes can be adjusted without displaying the labels,
so the labels can be rendered later if needed.
}}

\item{makeUnique}{\code{logical} indicating whether to display only the first
unique color. When \code{x} is supplied as a \code{list} this operation will
display the first unique color for each \code{list} element.
Also, when \code{x} is a \code{list}, just to be fancy, \code{makeUnique}
is recycled to \code{length(x)} so certain list elements can display
unique values, while others display all values.}

\item{doPlot}{\code{logical} indicating whether to produce a visual plot.
Note this function returns the color matrix invisibly.}

\item{...}{additional parameters are passed to \code{imageByColors()}.}
}
\value{
invisible color \code{matrix} used by \code{imageByColors()}. When
the input \code{x} is empty, or cannot be converted to colors when
\code{x} contains a \code{function}, the output returns \code{NULL}.
}
\description{
Show colors from a vector or list
}
\details{
This function simply displays colors for review, using
\code{imageByColors()} to display colors and labels across the
plot space.

When supplied a \code{list}, each row in \code{imageByColors()} represents
an entry in the \code{list}. Nothing fancy.
}
\examples{
x <- color2gradient(list(Reds=c("red"), Blues=c("blue")), n=c(4,7));
showColors(x);

showColors(getColorRamp("firebrick3"))

if (requireNamespace("RColorBrewer", quietly=TRUE)) {
   RColorBrewer_namelist <- rownames(RColorBrewer::brewer.pal.info);
   y <- lapply(nameVector(RColorBrewer_namelist), function(i){
      n <- RColorBrewer::brewer.pal.info[i, "maxcolors"]
      j <- RColorBrewer::brewer.pal(n, i);
      nameVector(j, seq_along(j));
   });
   showColors(y, cexCellnote=0.6, cex.axis=0.7, main="Brewer Colors");
}
if (requireNamespace("viridisLite", quietly=TRUE)) {
   # given one function name it will display discrete colors
   showColors(viridisLite::viridis)
   # a list of functions will show each function output
   showColors(list(viridis=viridisLite::viridis,
      inferno=viridisLite::inferno))

   # grab the full viridis color map
   z <- rgb2col(viridisLite::viridis.map[,c("R","G","B")]);
   # split the colors into a list
   viridis_names <- c(A="magma",
      B="inferno",
      C="plasma",
      D="viridis",
      E="cividis",
      F="rocket",
      G="mako",
      H="turbo")
   y <- split(z,
      paste0(viridisLite::viridis.map$opt, ": ",
      viridis_names[viridisLite::viridis.map$opt]));
   showColors(y, labelCells=TRUE, xaxt="n", main="viridis.map colors");
}

# demonstrate makeUnique=TRUE
j1 <- getColorRamp("rainbow", n=7);
names(j1) <- seq_along(j1);
j2 <- rep(j1, each=3);
names(j2) <- makeNames(names(j2), suffix="_rep");
j2
showColors(list(
   j1=j1,
   j2=j2,
   j3=j2),
   makeUnique=c(FALSE, FALSE, TRUE))

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}

Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
\concept{jam plot functions}
