% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\name{getSearchRuns}
\alias{getSearchRuns}
\title{Get search run data}
\usage{
getSearchRuns(data, problem, search)
}
\arguments{
\item{data}{data object containing the analysis results}

\item{problem}{name of the analyzed problem. Can be omitted if the
\code{data} contains results for a single problem only.}

\item{search}{name of the applied search. Can be omitted if the \code{data}
  contains results for a single search only (for the considered
  \code{problem}).}
}
\value{
A list containing one element for each search run.

  Each run has at least two elements \code{time} and \code{values}, which are
  both numeric vectors. The \code{time} vector indicates when the best
  solution was updated during search and the new best solution's value is
  found at the respective index in \code{values}. Times are expressed in
  milliseconds since starting the search. A time of -1 indicates that the
  search was not yet running, which e.g. occurs when a local search adopts a
  random current solution during initialization. Times are always positive
  (or -1) and increasing. Values are either increasing (in case of
  maximization) or decreasing (in case of minimization).

  If contained in the given \code{data}, a run also has an element
  \code{best.solution} representing the final best solution found during that
  search run. The last element of \code{values} then indicates the value of
  this best solution. When writing results obtained from the analysis tools
  in the 'JAMES' extensions module to a JSON file, one should provide a JSON
  converter for the solution type of the analyzed problems if it is desired
  that the actual best found solutions are contained in the output file.
}
\description{
Extract the data corresponding to the subsequent runs of a specific
\code{search} being applied to a specific \code{problem}. This is a generic
S3 method.
}
\details{
If the \code{data} contains results for a single problem only, the argument
\code{problem} can be omitted. Likewise, if for the considered \code{problem}
results are available for a single search only, the argument \code{search}
can be omitted.
}

