% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\name{reduceJAMES}
\alias{reduceJAMES}
\title{Reduce analysis results to selected problems and searches}
\usage{
reduceJAMES(data, problems = ".*", searches = ".*", ...)
}
\arguments{
\item{data}{data object containing the analysis results}

\item{problems}{\link{regular expression} or list of strings. Only those
problems that match the regular expression or occur in the list are
retained.}

\item{searches}{\link{regular expression} or list of strings. Only those
searches that match the regular expression or occur in the list are
retained.}

\item{...}{any additional arguments are passed to \code{\link{grep}}.}
}
\value{
Reduced data set containing only those problems and searches whose
  names match the respective regular expression or occur in the respective
  list of strings. Assigned classes are retained.
}
\description{
Reduce the given \code{data} by filtering the analyzed problems and applied
searches based on the given list of names or \link{regular expression}
(pattern matching is done with \code{\link{grep}}). This is a generic S3
method.
}

