% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_pct_formatting.R
\name{adorn_pct_formatting}
\alias{adorn_pct_formatting}
\title{Format a data.frame of decimals as percentages.}
\usage{
adorn_pct_formatting(dat, digits = 1, rounding = "half to even",
  affix_sign = TRUE)
}
\arguments{
\item{dat}{a data.frame with decimal values, typically the result of a call to \code{adorn_percentages} on a \code{tabyl}.  If given a list of data.frames, this function will apply itself to each data.frame in the list (designed for 3-way \code{tabyl} lists).}

\item{digits}{how many digits should be displayed after the decimal point?}

\item{rounding}{method to use for rounding - either "half to even", the base R default method, or "half up", where 14.5 rounds up to 15.}

\item{affix_sign}{should the \% sign be affixed to the end?}
}
\value{
a data.frame with formatted percentages
}
\description{
Numeric columns get multiplied by 100 and formatted as percentages according to user specifications.  This function excludes the first column of the input data.frame, assuming that it contains a descriptive variable.  Other non-numeric columns are also excluded.
}
\examples{

mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_percentages("col") \%>\%
  adorn_pct_formatting()
}
