% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{mesh_distance}
\alias{mesh_distance}
\title{Distance between meshes}
\usage{
mesh_distance(mesh, mesh_to, close = FALSE, type = "keep_na")
}
\arguments{
\item{mesh}{A \code{mesh} vector or a list of \code{mesh} vector.}

\item{mesh_to}{A \code{mesh} vector.}

\item{close}{Should the path of each element be closed when \code{mesh} is a list?}

\item{type}{How is the NA mesh treated when \code{mesh} is a list? \code{"skip_na"} skips the \code{NA} mesh and connects the paths.
\code{"keep_na"} by default.}
}
\value{
A double vector.
}
\description{
If \code{mesh} and \code{mesh_to} are both vectors, the distance between \code{mesh} and \code{mesh_to} is calculated.
If \code{mesh} is a list, The path distance of each element is calculated.
}
