% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.R
\name{run_script}
\alias{run_script}
\title{Execute an R script inside a Docker container}
\usage{
run_script(
  file,
  ...,
  context = dirname(file),
  image = paste0("r-base:", r_version()),
  stdout = "",
  stderr = "",
  install_dependencies = FALSE,
  r_profile = jetty_r_profile(),
  r_environ = jetty_r_environ(),
  debug = FALSE
)
}
\arguments{
\item{file}{A character string giving the pathname of the file to read from.}

\item{...}{Additional arguments to be passed directly to \code{\link{source}}.}

\item{context}{The pathname of the directory to serve as the execution context.
This directory will be mounted to the Docker container, which
means that the script will have access to all files/directories that are
within the context directory. The context will also serve as the working
directory from which the script is executed. It is crucial to note that the
script will NOT be able to access any files/directories that are outside the
scope of the context directory. The default value is the directory that
\code{file} is contained in.}

\item{image}{A string in the \code{image:tag} format specifying either a local
Docker image or an image available on DockerHub. Default image is
\code{r-base:{jetty:::r_version()}} where your R version is determined from
your local R session.}

\item{stdout, stderr}{where output to ‘stdout’ or ‘stderr’ should be sent.
Possible values are "", to the R console (the default), NULL
(discard output), FALSE (discard output), TRUE
(capture the output silently and then discard), or a
character string naming a file. See \code{\link{system2}} which this
function uses under the hood; however, note that \code{\link{system2}}
handles these options slightly differently.}

\item{install_dependencies}{A boolean indicating whether jetty should
discover packages used in your code and try to install them in the
Docker container prior to executing the provided function/expression.
In general, things will work better if the Docker image already has all
necessary packages installed.}

\item{r_profile, r_environ}{Paths specifying where jetty should search for
the .Rprofile and .Renviron files to transfer to the Docker sub-process.
By default jetty will look for files called ".Rprofile" and ".Renviron"
in the current working directory. If either file is found, they will be
transferred to the Docker sub-process and loaded before executing any
R commands. To explicitly exclude either file, set the value to
\code{NULL}. Alternatively, to exclude either file for all jetty function
calls, set the \code{JETTY_IGNORE_RPROFILE}/\code{JETTY_IGNORE_RENVIRON}
environment variable(s) to one of \code{c(TRUE, "T")} or set the R
option(s) \code{jetty.ignore.rprofile}/\code{jetty.ignore.renviron}
\code{TRUE}.}

\item{debug}{A boolean indicating whether to print out the commands that are
being executed via the shell. This is mostly helpful to see what is
happening when things start to error.}
}
\value{
The value of the last evaluated expression in the script.
}
\description{
This function is somewhat similar in spirit to
\code{callr::rscript()} in that the user can specify
an R script to be executed within the context of a Docker container.
}
\details{
\bold{NOTE}: this feature is still fairly experimental. It will \emph{NOT}
work on Windows. It is only made to be compatible with MacOS and Linux.
}
\section{Interaction with the local file system}{


The user will be asked to specify a \code{context} (local directory)
for executing the R script. jetty mounts this directory to the Docker
container, allowing the script to interact with files within it
(read/write). Attempts to access files outside the context directory
will cause the script to fail. Ensure the context directory includes
all files needed for the script to run.
}

\section{Error handling}{


\code{run_script} will handle errors using the same mechanism as
\code{\link{run}}. See that documentation for more details.
}

\examples{
\dontrun{
# Execute a simple script that has no package dependencies
run_script(file = here::here("code/analysis_script.R"))

# Execute a script that needs access to the entire analysis directory
run_script(
  file = here::here("code/analysis_script.R"),
  context = here::here()
)

# Execute a script that needs access to the entire analysis directory
# and relies on external packages
run_script(
  file = here::here("code/analysis_script.R"),
  context = here::here(),
  install_dependencies = TRUE
)

# Execute a script and explicitly ignore an existing .Rprofile
run_script(
  file = here::here("code/analysis_script.R"),
  r_profile = NULL
)
}

}
