% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_clusters.R
\name{extract_empirical_clusters}
\alias{extract_empirical_clusters}
\title{Detect largest clusters from a time sequence of predictor statistics}
\usage{
extract_empirical_clusters(
  empirical_statistics,
  threshold,
  binned = FALSE,
  top_n = Inf
)
}
\arguments{
\item{empirical_statistics}{A predictor-by-time matrix of empirical timewise statistics.}

\item{threshold}{The threshold value that the statistic must pass to contribute to cluster mass.
Interpretation differs on the choice of statistic (more below):
\itemize{
\item If \code{statistic = "t"}, the threshold for t-value (beta/std.err) from the regression model.
\item If \code{statistic = "chisq"}, the threshold for the p-value of chi-squared statistics from likelihood ratio tests.
}}

\item{binned}{Whether the data has been aggregated/collapsed into time bins. Defaults to \code{FALSE},
which requires a cluster to span at least two time points. If \code{TRUE}, allows length-1 clusters to exist.}

\item{top_n}{How many clusters to return, in the order of the size of the cluster-mass statistic.
Defaults to \code{Inf} which return all detected clusters.}
}
\value{
An \code{empirical_clusters} object.
}
\description{
Detect largest clusters from a time sequence of predictor statistics
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(verbose = FALSE)
julia_progress(show = FALSE)
}

library(dplyr, warn.conflicts = FALSE)

# Specification object
spec <- make_jlmer_spec(
  weight ~ 1 + Diet, filter(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec

# Empirical clusters are derived from the timewise statistics
empirical_statistics <- compute_timewise_statistics(spec)
empirical_clusters <- extract_empirical_clusters(empirical_statistics, threshold = 2)
empirical_clusters

# Collect as dataframe with `tidy()`
empirical_clusters_df <- tidy(empirical_clusters)
empirical_clusters_df

# Changing the `threshold` value identifies different clusters
extract_empirical_clusters(empirical_statistics, threshold = 1)

# A predictor can have zero or multiple clusters associated with it
extract_empirical_clusters(empirical_statistics, threshold = 3)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=compute_timewise_statistics]{compute_timewise_statistics()}}
}
