% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmbayesBig.R
\name{jmbayesBig}
\alias{jmbayesBig}
\title{Joint model for BIG data using JMbayes2}
\usage{
jmbayesBig(
  dtlong,
  dtsurv,
  longm,
  survm,
  samplesize = 50,
  rd,
  timeVar,
  nchain = 1,
  id,
  niter = 2000,
  nburnin = 1000
)
}
\arguments{
\item{dtlong}{longitudinal dataset, which contains id,visit time,longitudinal measurements along with various covariates}

\item{dtsurv}{survival dataset corresponding to the longitudinal dataset, with survival status and survival time}

\item{longm}{fixed effect model for longitudinal response}

\item{survm}{survival model}

\item{samplesize}{sample size to divide the Big data}

\item{rd}{random effect model part}

\item{timeVar}{time variable in longitudinal model, included in the longitudinal data}

\item{nchain}{number of chain for MCMC}

\item{id}{name of id column in longitudinal dataset}

\item{niter}{number of iteration for MCMC chain}

\item{nburnin}{number of burnin sample for MCMC chain}
}
\value{
returns a list containing various output which are useful for prediction.
}
\description{
function for joint model in BIG DATA using JMbayes2
}
\examples{

 \donttest{
##
library(survival)
library(nlme)
library(dplyr)
fit5<-jmbayesBig(dtlong=long2,dtsurv = surv2,longm=y~ x7+visit,survm=Surv(time,status)~x1+visit,
rd= ~ visit|id,timeVar='visit',nchain=1,samplesize=200,id='id')
ydt<-long2\%>\%filter(id\%in\%c(900))
cdt<-surv2[,'id']\%>\%filter(id\%in\%c(900))
newdata<-full_join(ydt,cdt,by='id')
P2<-predJMbayes(model<-fit5,ids<-c(900),newdata=newdata,process = 'event')
pp1<-plot(P2$p1[[1]])
##
}
}
\references{
Rizopoulos, D., G. Papageorgiou, and P. Miranda Afonso. "JMbayes2: extended joint models for longitudinal and time-to-event data." R package version 0.2-4 (2022).
}
\seealso{
\link{jmcsBig},\link{jmstanBig},\link{joinRMLBig}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
