% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getJMCM}
\alias{getJMCM}
\alias{getJMCM.jmcmMod}
\title{Extract or Get Generalized Components from a Fitted Joint Mean
Covariance Model}
\usage{
getJMCM(object, name, sub.num)

\method{getJMCM}{jmcmMod}(object, name = c("m", "Y", "X", "Z", "W", "D", "T",
  "Sigma", "mu", "theta", "beta", "lambda", "gamma", "loglik", "BIC", "iter",
  "triple"), sub.num = 0)
}
\arguments{
\item{object}{a fitted joint mean covariance model of class "jmcmMod", i.e.,
typically the result of jmcm().}

\item{name}{a character vector specifying the name(s) of the "component".

When sub.num is not specified or equal to 0, possible values are:
\describe{
  \item{\code{"m"}}{a vector of number of measurement for each subject}
  \item{\code{"Y"}}{response vector}
  \item{\code{"X"}}{model matrix for mean structure}
  \item{\code{"Z"}}{model matrix for covariance structure (the diagonal
  matrix)}
  \item{\code{"W"}}{model matrix for covariance structure (the lower
  triangular matrix)}
  \item{\code{"theta"}}{parameter estimates of joint mean covariance model}
  \item{\code{"beta"}}{parameter estimates for mean structure model}
  \item{\code{"lambda"}}{parameter estimates for covariace structure (the
  diagonal matrix)}
  \item{\code{"gamma"}}{parameter estimates for covariance structure (the
  lower triangular matrix)}
  \item{\code{"loglik"}}{log-likelihood, except for a constant}
  \item{\code{"BIC"}}{Bayesian information criterion}
  \item{\code{"iter"}}{number of iterations until convergence}
  \item{\code{"triple"}}{(p, d, q)}
}

When sub.num is specified, possible values are:
\describe{
  \item{\code{"m"}}{number of measurements for subject i}
  \item{\code{"Y"}}{response vector for subject i}
  \item{\code{"X"}}{model matrix of subject i for mean structure }
  \item{\code{"Z"}}{model matrix of subject i for covariance structure (the
  diagonal matrix)}
  \item{\code{"W"}}{model matrix of subject i for covariance structure (the
  lower triangular matrix)}
  \item{\code{"D"}}{the estimated diagonal matrix for subject i}
  \item{\code{"T"}}{the estimated lower triangular matrix for subject i}
  \item{\code{"Sigma"}}{the estimated covariance matrix for subject i}
  \item{\code{"mu"}}{the estimated mean for subject i}
}}

\item{sub.num}{refer to i's subject}
}
\description{
Extract (or "get") "components" - in a generalized sense - from
a fitted joint mean covariance model from an object of class "jmcmMod".
}
\section{Methods (by class)}{
\itemize{
\item \code{jmcmMod}: Extract or Get Generalized Components from a Fitted Joint
Mean Covariance Model
}}

\examples{
fit.mcd <- jmcm(I(sqrt(cd4)) | id | time ~ 1 | 1, data = aids,
  triple = c(8, 1, 3), cov.method = 'mcd')

beta <- getJMCM(fit.mcd, "beta")
BIC  <- getJMCM(fit.mcd, "BIC")
Di   <- getJMCM(fit.mcd, "D", 10)

}
