% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.h.R
\name{descriptives}
\alias{descriptives}
\title{Descriptives}
\usage{
descriptives(data, vars, mean = TRUE, median = TRUE, mode = FALSE,
  sum = FALSE, sd = FALSE, variance = FALSE, range = FALSE,
  min = TRUE, max = TRUE, se = FALSE, skew = FALSE, kurt = FALSE,
  freq = FALSE, plots = FALSE, plotW = 480, plotH = 320,
  quart = FALSE, pcEqGr = FALSE, pcNEqGr = 4)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in 
\code{data}}

\item{mean}{\code{TRUE} (default) or \code{FALSE}, provide the mean}

\item{median}{\code{TRUE} (default) or \code{FALSE}, provide the median}

\item{mode}{\code{TRUE} or \code{FALSE} (default), provide the mode}

\item{sum}{\code{TRUE} or \code{FALSE} (default), provide the sum}

\item{sd}{\code{TRUE} or \code{FALSE} (default), provide the standard 
deviation}

\item{variance}{\code{TRUE} or \code{FALSE} (default), provide the variance}

\item{range}{\code{TRUE} or \code{FALSE} (default), provide the range}

\item{min}{\code{TRUE} or \code{FALSE} (default), provide the minimum}

\item{max}{\code{TRUE} or \code{FALSE} (default), provide the maximum}

\item{se}{\code{TRUE} or \code{FALSE} (default), provide the standard error}

\item{skew}{\code{TRUE} or \code{FALSE} (default), provide the skewness}

\item{kurt}{\code{TRUE} or \code{FALSE} (default), provide the kurtosis}

\item{freq}{\code{TRUE} or \code{FALSE} (default), provide frequency tables 
(nominal, ordinal variables only)}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide frequency 
tables (nominal, ordinal variables only)}

\item{plotW}{an integer (default: 480) specifying the width of the plots}

\item{plotH}{an integer (default: 320) specifying the height of the plots}

\item{quart}{\code{TRUE} or \code{FALSE} (default), provide quartiles}

\item{pcEqGr}{\code{TRUE} or \code{FALSE} (default), provide quantiles}

\item{pcNEqGr}{an integer (default: 4) specifying the number of equal 
groups}
}
\description{
Provides a range of descriptive statistics
}
\examples{
\dontrun{
descriptives(data, vars=c('x', 'y', 'z'))
}
}

