% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovaonew.h.R
\name{anovaOneW}
\alias{anovaOneW}
\title{One-Way ANOVA}
\usage{
anovaOneW(data, deps, group, welchs = TRUE, fishers = FALSE,
  miss = "perAnalysis", desc = FALSE, descPlot = FALSE, norm = FALSE,
  qq = FALSE, eqv = FALSE, phMethod = "none", phMeanDif = TRUE,
  phSig = TRUE, phTest = FALSE, phFlag = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{deps}{a string naming the dependent variables in \code{data}}

\item{group}{a string naming the grouping or independent variable in
\code{data}}

\item{welchs}{\code{TRUE} (default) or \code{FALSE}, perform Welch's
one-way ANOVA which does not assume equal variances}

\item{fishers}{\code{TRUE} or \code{FALSE} (default), perform Fisher's
one-way ANOVA which assumes equal variances}

\item{miss}{\code{'perAnalysis'} or \code{'listwise'}, how to handle
missing values; \code{'perAnalysis'} excludes missing values for individual
dependent variables, \code{'listwise'} excludes a row from all analyses if
one of its entries is missing.}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{descPlot}{\code{TRUE} or \code{FALSE} (default), provide descriptive
plots}

\item{norm}{\code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk
test of normality}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
residuals}

\item{eqv}{\code{TRUE} or \code{FALSE} (default), perform Levene's test for
equality of variances}

\item{phMethod}{\code{'none'}, \code{'gamesHowell'} or \code{'tukey'},
which post-hoc tests to provide; \code{'none'} shows no post-hoc tests,
\code{'gamesHowell'} shows Games-Howell post-hoc tests where no equivalence
of variances is assumed, and \code{'tukey'} shows Tukey post-hoc tests
where equivalence of variances is assumed}

\item{phMeanDif}{\code{TRUE} (default) or \code{FALSE}, provide mean
differences for post-hoc tests}

\item{phSig}{\code{TRUE} (default) or \code{FALSE}, provide significance
levels for post-hoc tests}

\item{phTest}{\code{TRUE} or \code{FALSE} (default), provide test results
(t-value and degrees of freedom) for post-hoc tests}

\item{phFlag}{\code{TRUE} or \code{FALSE} (default), flag significant
post-hoc comparisons}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$anova} \tab \tab \tab \tab \tab a table of the test results \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table containing the group descriptives \cr
  \code{results$assump$norm} \tab \tab \tab \tab \tab a table containing the normality tests \cr
  \code{results$assump$eqv} \tab \tab \tab \tab \tab a table of equality of variances tests \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of groups of plots \cr
  \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$anova$asDF}

\code{as.data.frame(results$anova)}
}
\description{
One-Way ANOVA
}
\examples{
data('ToothGrowth')
dat <- ToothGrowth
dat$dose <- factor(dat$dose)

anovaOneW(dat, deps = "len", group = "dose")

#
#  ONE-WAY ANOVA
#
#  One-Way ANOVA (Welch's)
#  ----------------------------------------
#           F       df1    df2     p
#  ----------------------------------------
#    len    68.4      2    37.7    < .001
#  ----------------------------------------
#

}
