% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_omv.R
\name{sort_omv}
\alias{sort_omv}
\title{Sort data (using one or more variables) in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})}
\usage{
sort_omv(
  fleInp = c(),
  fleOut = "",
  varSrt = c(),
  usePkg = c("foreign", "haven"),
  selSet = "",
  ...
)
}
\arguments{
\item{fleInp}{Name (including the path, if required) of the data file to be read ("FILENAME.ext"; default: ""); can be any supported file type, see Details below}

\item{fleOut}{Name (including the path, if required) of the data file to be written ("FILENAME.omv"; default: ""); if empty, the extension of fleInp is replaced with "_sorted(file extension -> .omv)"}

\item{varSrt}{Variable(s) that are used to sort the data frame (see Details; default: c())}

\item{usePkg}{Name of the package: "foreign" or "haven" that shall be used to read SPSS, Stata and SAS files; "foreign" is the default (it comes with base R), but "haven" is newer and more comprehensive}

\item{selSet}{Name of the data set that is to be selected from the workspace (only applies when reading .RData-files)}

\item{...}{Additional arguments passed on to methods; see Details below}
}
\description{
Sort data (using one or more variables) in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})
}
\details{
varSrt can be either a character or a character vector (with one or more variables respectively). The sorting order for a particular variable can be inverted with preceding the variable name with
"-". Please note that this doesn't make sense and hence throws a warning for certain variable types (e.g., factors).
The ellipsis-parameter can be used to submit arguments / parameters to the functions that are used for reading the data. These are: \code{read_omv} (for jamovi-files), \code{read.table} (for CSV / TSV
files; using similar defaults as \code{read.csv} for CSV and \code{read.delim} for TSV which both are based upon \code{read.table} but with adjusted defaults for the respective file types), \code{readRDS} (for
rds-files), \code{read_sav} (needs R-package "haven") or \code{read.spss} (needs R-package "foreign") for SPSS-files, \code{read_dta} ("haven") / \code{read.dta} ("foreign") for Stata-files, \code{read_sas} ("haven") for
SAS-data-files, and \code{read_xpt} ("haven") / \code{read.xport} ("foreign") for SAS-transport-files. If you would like to use "haven", it may be needed to install it manually
(i.e., \code{install.packages("haven", dep = TRUE)}).
}
\examples{
\dontrun{
library(jmvReadWrite)
fleOMV <- system.file("extdata", "AlbumSales.omv", package = "jmvReadWrite")
fleTmp <- paste0(tempfile(), ".omv")
sort_omv(fleInp = fleOMV, fleOut = fleTmp, varSrt = "Image")
dtaFrm <- read_omv(fleInp = fleTmp)
cat(dtaFrm$Image)
# shows that the variable "Image" is sorted in ascending order
cat(is.unsorted(dtaFrm$Image))
# is.unsorted (which checks for whether the variable is NOT sorted) returns FALSE
sort_omv(fleInp = fleOMV, fleOut = fleTmp, varSrt = "-Image")
# variables can also be sorted in descending order by preceding them with "-"
dtaFrm <- read_omv(fleInp = fleTmp)
cat(dtaFrm$Image)
# shows that the variable "Image" is now sorted in descending order
cat(is.unsorted(dtaFrm$Image))
# this first returns TRUE (the variable is not in ascending order, i.e., unsorted)
cat(is.unsorted(-dtaFrm$Image))
# if the sign of the variable is changed, it returns FALSE (i.e., the variable is
# NOT unsorted)
unlink(fleTmp)
}

}
