% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.r
\name{Job}
\alias{Job}
\title{How to Evaluate an R Expression}
\description{
The Job object encapsulates an expression and its evaluation parameters. It
also provides a way to check for and retrieve the result.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{expr}}{R expression that will be run by this Job.}

\item{\code{vars}}{Get or set - List of variables that will be placed into the expression's
environment before evaluation.}

\item{\code{reformat}}{Get or set - \verb{function (job)} for defining \verb{<Job>$result}.}

\item{\code{signal}}{Get or set - Conditions to signal.}

\item{\code{cpus}}{Get or set - Number of CPUs to reserve for evaluating \code{expr}.}

\item{\code{timeout}}{Get or set - Time limits to apply to this Job.}

\item{\code{proxy}}{Get or set - Job to proxy in place of running \code{expr}.}

\item{\code{state}}{Get or set - The Job's state: \code{'created'}, \code{'submitted'}, \code{'queued'},
\code{'dispatched'}, \code{'starting'}, \code{'running'}, or \code{'done'}.
\emph{Assigning to \verb{<Job>$state} will trigger callback hooks.}}

\item{\code{output}}{Get or set - Job's raw output.
\emph{Assigning to \verb{<Job>$output} will change the Job's state to \code{'done'}.}}

\item{\code{result}}{Result of \code{expr}. Will block until Job is finished.}

\item{\code{hooks}}{Currently registered callback hooks as a named list of functions.
Set new hooks with \verb{<Job>$on()}.}

\item{\code{is_done}}{\code{TRUE} or \code{FALSE} depending on if the Job's result is ready.}

\item{\code{uid}}{A short string, e.g. \code{'J16'}, that uniquely identifies this Job.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Job-new}{\code{Job$new()}}
\item \href{#method-Job-print}{\code{Job$print()}}
\item \href{#method-Job-on}{\code{Job$on()}}
\item \href{#method-Job-wait}{\code{Job$wait()}}
\item \href{#method-Job-stop}{\code{Job$stop()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-new"></a>}}
\if{latex}{\out{\hypertarget{method-Job-new}{}}}
\subsection{Method \code{new()}}{
Creates a Job object defining how to run an expression on a background worker process.

\emph{Typically you won't need to call \code{Job$new()}. Instead, create a \link{Queue} and use
\verb{<Queue>$run()} to generate Job objects.}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$new(
  expr,
  vars = NULL,
  timeout = NULL,
  hooks = NULL,
  reformat = NULL,
  signal = FALSE,
  cpus = 1L,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{A call or R expression wrapped in curly braces to evaluate on a
worker. Will have access to any variables defined by \code{vars}, as well
as the Worker's \code{globals}, \code{packages}, and \code{init} configuration.
See \code{vignette('eval')}.}

\item{\code{vars}}{A named list of variables to make available to \code{expr} during
evaluation. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.
Or a \verb{function (job)} that returns such an object.}

\item{\code{timeout}}{A named numeric vector indicating the maximum number of
seconds allowed for each state the job passes through, or 'total' to
apply a single timeout from 'submitted' to 'done'. Or a
\verb{function (job)} that returns the same. Example:
\code{timeout = c(total = 2.5, running = 1)}. See \code{vignette('stops')}.}

\item{\code{hooks}}{A named list of functions to run when the Job state changes,
of the form \code{hooks = list(created = function (worker) {...})}. Or a
\verb{function (job)} that returns the same. Names of worker hooks are
typically \code{'created'}, \code{'submitted'}, \code{'queued'}, \code{'dispatched'},
\code{'starting'}, \code{'running'}, \code{'done'}, or \code{'*'} (duplicates okay).
See \code{vignette('hooks')}.}

\item{\code{reformat}}{Set \verb{reformat = function (job)} to define what
\verb{<Job>$result} should return. The default, \code{reformat = NULL} passes
\verb{<Job>$output} to \verb{<Job>$result} unchanged.
See \code{vignette('results')}.}

\item{\code{signal}}{Should calling \verb{<Job>$result} signal on condition objects?
When \code{FALSE}, \verb{<Job>$result} will return the object without
taking additional action. Setting to \code{TRUE} or a character vector of
condition classes, e.g. \code{c('interrupt', 'error', 'warning')}, will
cause the equivalent of \verb{stop(<condition>)} to be called when those
conditions are produced. Alternatively, a \verb{function (job)} that
returns \code{TRUE} or \code{FALSE}. See \code{vignette('results')}.}

\item{\code{cpus}}{How many CPU cores to reserve for this Job.  Or a
\verb{function (job)} that returns the same. Used to limit the number of
Jobs running simultaneously to respect \verb{<Queue>$max_cpus}. Does not
prevent a Job from using more CPUs than reserved.}

\item{\code{...}}{Arbitrary named values to add to the returned Job object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Job object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-print"></a>}}
\if{latex}{\out{\hypertarget{method-Job-print}{}}}
\subsection{Method \code{print()}}{
Print method for a Job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments are not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This Job, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-on"></a>}}
\if{latex}{\out{\hypertarget{method-Job-on}{}}}
\subsection{Method \code{on()}}{
Attach a callback function to execute when the Job enters \code{state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$on(state, func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a Job state. Typically one of:
\itemize{
\item \code{'*'} -          Every time the state changes.
\item \code{'.next'} -      Only one time, the next time the state changes.
\item \code{'created'} -    After \code{Job$new()} initialization.
\item \code{'submitted'} -  After \verb{<Job>$queue} is assigned.
\item \code{'queued'} -     After \code{stop_id} and \code{copy_id} are resolved.
\item \code{'dispatched'} - After \verb{<Job>$worker} is assigned.
\item \code{'starting'} -   Before evaluation begins.
\item \code{'running'} -    After evaluation begins.
\item \code{'done'} -       After \verb{<Job>$output} is assigned.
}

Custom states can also be specified.}

\item{\code{func}}{A function that accepts a Job object as input. You can call
\verb{<Job>$stop()} or edit \verb{<Job>$} values and the changes will be
persisted (since Jobs are reference class objects). You can also
edit/stop other queued jobs by modifying the Jobs in
\verb{<Job>$queue$jobs}. Return value is ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that when called removes this callback from the Job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-wait"></a>}}
\if{latex}{\out{\hypertarget{method-Job-wait}{}}}
\subsection{Method \code{wait()}}{
Blocks until the Job enters the given state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$wait(state = "done", timeout = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a Job state. Typically one of:
\itemize{
\item \code{'*'} -          Every time the state changes.
\item \code{'.next'} -      Only one time, the next time the state changes.
\item \code{'created'} -    After \code{Job$new()} initialization.
\item \code{'submitted'} -  After \verb{<Job>$queue} is assigned.
\item \code{'queued'} -     After \code{stop_id} and \code{copy_id} are resolved.
\item \code{'dispatched'} - After \verb{<Job>$worker} is assigned.
\item \code{'starting'} -   Before evaluation begins.
\item \code{'running'} -    After evaluation begins.
\item \code{'done'} -       After \verb{<Job>$output} is assigned.
}

Custom states can also be specified.}

\item{\code{timeout}}{Stop the Job if it takes longer than this number of seconds, or \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This Job, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Job-stop}{}}}
\subsection{Method \code{stop()}}{
Stop this Job. If the Job is running, its Worker will be restarted.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$stop(reason = "job stopped by user", cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reason}}{A message to include in the 'interrupt' condition object that
will be returned as the Job's result.}

\item{\code{cls}}{Character vector of additional classes to prepend to
\code{c('interrupt', 'condition')}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This Job, invisibly.
}
}
}
