% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.mjoint.R
\name{formula.mjoint}
\alias{formula.mjoint}
\title{Extract model formulae from an \code{mjoint} object}
\usage{
\method{formula}{mjoint}(x, process = c("Longitudinal", "Event"), k = 1, ...)
}
\arguments{
\item{x}{an object inheriting from class \code{mjoint} for a joint model of
time-to-event and multivariate longitudinal data.}

\item{process}{character string: if \code{process='Longitudinal'} a fixed
effects formula from the (multivariate) longitudinal sub-model is returned
for the \code{k}-th outcome. Else, if \code{process='Event'}, the
time-to-event model formula is returned.}

\item{k}{integer: a number between 1 and \emph{K} (the total number of
longitudinal outcomes) that specifies the longitudinal outcome of interest.}

\item{...}{additional arguments; currently none are used.}
}
\value{
An object of class "formula" which contains a symbolic model formula
  for the separate sub-model fixed effect terms only.
}
\description{
Extract model formulae from an \code{mjoint} object.
}
\references{
Pinheiro JC, Bates DM. \emph{Mixed-Effects Models in S and S-PLUS.} New York:
Springer Verlag; 2000.

Wulfsohn MS, Tsiatis AA. A joint model for survival and longitudinal data
measured with error. \emph{Biometrics.} 1997; \strong{53(1)}: 330-339.
}
\seealso{
\code{\link[stats]{formula}} for the generic method description, and
  \code{\link{ranef.mjoint}}.
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{methods}
