% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dynLong.R
\name{plot.dynLong}
\alias{plot.dynLong}
\title{Plot a \code{dynLong} object}
\usage{
\method{plot}{dynLong}(x, main = NULL, xlab = NULL, ylab = NULL, grid = TRUE, estimator, ...)
}
\arguments{
\item{x}{an object of class \code{dynLong} calculated by the
\code{\link{dynLong}} function.}

\item{main}{an overall title for the plot: see \code{\link[graphics]{title}}.}

\item{xlab}{a title for the x [time] axis: see \code{\link[graphics]{title}}.}

\item{ylab}{a character vector of the titles for the \emph{K} longitudinal
outcomes y-axes: see \code{\link[graphics]{title}}.}

\item{grid}{adds a rectangular grid to an existing plot: see
\code{\link[graphics]{grid}}.}

\item{estimator}{a character string that can take values \code{mean} or
\code{median} to specify what prediction statistic is plotted from an
objecting inheritting of class \code{dynSurv}. Default is
\code{estimator='median'}. This argument is ignored for non-simulated
\code{dynSurv} objects, i.e. those of \code{type='first-order'}, as in that
case a mode-based prediction is plotted.}

\item{...}{additional plotting arguments; currently limited to \code{lwd} and
\code{cex}. See \code{\link[graphics]{par}} for details.}
}
\value{
A dynamic prediction plot.
}
\description{
Plots the conditional longitudinal expectations for a
  \emph{new} subject calculated using the \code{\link{dynLong}} function.
}
\examples{
\dontrun{
# Fit a joint model with bivariate longitudinal outcomes

data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]

fit2 <- mjoint(
    formLongFixed = list("grad" = log.grad ~ time + sex + hs,
                         "lvmi" = log.lvmi ~ time + sex),
    formLongRandom = list("grad" = ~ 1 | num,
                          "lvmi" = ~ time | num),
    formSurv = Surv(fuyrs, status) ~ age,
    data = list(hvd, hvd),
    inits = list("gamma" = c(0.11, 1.51, 0.80)),
    timeVar = "time",
    verbose = TRUE)

hvd2 <- droplevels(hvd[hvd$num == 1, ])
out <- dynLong(fit2, hvd2)
plot(out, main = "Patient 1")
}
}
\references{
Rizopoulos D. Dynamic predictions and prospective accuracy in joint models
for longitudinal and time-to-event data. \emph{Biometrics}. 2011;
\strong{67}: 819–829.
}
\seealso{
\code{\link{dynLong}}
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{hplot}
