% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{funs}
\alias{funs}
\title{Define and use functions}
\usage{
funs(.data, fxn, action)
}
\arguments{
\item{.data}{input}

\item{fxn}{A function definition, without \code{def} (added internally)}

\item{action}{What to do with the function on the data}
}
\description{
Define and use functions
}
\examples{
jq("[1,2,10,20]", 'def increment: . + 1; map(increment)')
"[1,2,10,20]" \%>\% funs('increment: . + 1', 'map(increment)')
"[1,2,10,20]" \%>\% funs('increment: . / 100', 'map(increment)')
"[1,2,10,20]" \%>\% funs('increment: . / 100', 'map(increment)')
'[[1,2],[10,20]]' \%>\% funs('addvalue(f): f as $x | map(. + $x)', 'addvalue(.[0])')
"[1,2]" \%>\% funs('f(a;b;c;d;e;f): [a+1,b,c,d,e,f]', 'f(.[0];.[1];.[0];.[0];.[0];.[0])')
"[1,2,3,4]" \%>\% funs('fac: if . == 1 then 1 else . * (. - 1 | fac) end', '[.[] | fac]')
}

