% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{openPage}
\alias{openPage}
\title{Create a server}
\usage{
openPage(useViewer = T, rootDirectory = NULL, startPage = NULL)
}
\arguments{
\item{useViewer}{If \code{TRUE}, the start page will be opened in the RStudio Viewer. If \code{FALSE}
a default web browser will be used.}

\item{rootDirectory}{A path to the root directory of the server. If \code{rootDirectory} is not 
defined, the \code{http_root} in the package directory will be used as a root directory.}

\item{startPage}{A path to the HTML file that should be opened, when the server is initialised.
This can be an absolute path to a local file, or it can be relative to the \code{rootDirectory}
or to the current R working directory. If \code{startPage} is not defined, this function opens an 
empty HTML page. The file must have \emph{.html} extension.}
}
\description{
\code{openPage} creates a server and establishes a websocket connection between it and the current
R session. This allows commands exchange. In R use \code{\link{sendCommand}} function to send and 
execute JavaScript code on the server. On the server use \code{jrc.sendCommand} function to send and
execute R code in the current R session.
}
