% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{allowVariables}
\alias{allowVariables}
\title{Allow variable assignment without authorization}
\usage{
allowVariables(vars = NULL)
}
\arguments{
\item{vars}{Vector of variable names to be added to the list. If is \code{NULL},
returns names of all currently allowed variables.}
}
\value{
Names of all currently allowed variables if \code{vars = NULL}.
}
\description{
This function adds variable names to the list of variables, which
can be reassigned from the web page without manual confirmation in the R
session.
}
\examples{
allowVariables(c("myVariable", "anotherOne"))
vars <- allowVariables()

}
\seealso{
\code{\link{allowFunctions}}, \code{\link{authorize}}, \code{\link{openPage}} (check argument
\code{allowedVariables}), \code{\link{sendData}}.
}
