% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_json.R
\name{read_json}
\alias{read_json}
\alias{write_json}
\title{Read/write JSON}
\usage{
read_json(path, simplifyVector = FALSE, ...)

write_json(x, path, ...)
}
\arguments{
\item{path}{file on disk}

\item{simplifyVector}{simplifies nested lists into vectors and data frames. See \link{fromJSON}.}

\item{...}{additional arguments passed to \link{toJSON} or \link{fromJSON}}

\item{x}{an object to be serialized to JSON}
}
\description{
Convenience wrappers around \link{toJSON} and \link{fromJSON} to read and
write directly to/from disk.
}
\examples{
tmp <- tempfile()
write_json(iris, tmp)

# Nested lists
read_json(tmp)

# A data frame
read_json(tmp, simplifyVector = TRUE)
}
