% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_hoist.R
\name{json_hoist}
\alias{json_hoist}
\title{Rectangle a JSON vector}
\usage{
json_hoist(
  .data,
  .col,
  ...,
  .remove = TRUE,
  .ptype = list(),
  .wrap_scalars = list(),
  .default = list(),
  .na = list(),
  bigint_as_char = bigint_default()
)
}
\arguments{
\item{.data}{A data frame.}

\item{.col}{JSON-column.}

\item{...}{Elements of \code{.col} to turn into columns in the form
\code{col_name = "JSON path"}.}

\item{.remove}{If \code{TRUE}, the default, will remove the column \code{.col}.}

\item{.ptype, .wrap_scalars, .default, .na, bigint_as_char}{Optionally, a named
list of parameters passed to \code{\link[=json_extract]{json_extract()}}.}
}
\value{
A data frame, or subclass of data frame with new columns as
specified in \code{...}.
}
\description{
Rectangle a JSON vector
}
\examples{
df <- tibble::tibble(
  id = 1:5,
  json = json_flatten(got_chars_json)
)
json_hoist(df, json, url = "$.url", name = "$.name")

# the names can also be generated automatically
json_hoist(df, json, "$.url", "$.name")
}
