% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jtdm_fit.R
\name{plot.jtdm_fit}
\alias{plot.jtdm_fit}
\title{Plots the parameters of a fitted jtdm}
\usage{
\method{plot}{jtdm_fit}(x, ...)
}
\arguments{
\item{x}{a model fitted with \code{jtdm_fit}}

\item{...}{additional arguments}
}
\value{
A plot of the regression coefficients and covariance matrix of the fitted model
}
\description{
Plots the regression coefficients and covariance matrix of a fitted jtdm
}
\examples{
data(Y)  
data(X)  
m = jtdm_fit(Y=Y, X=X, 
             formula=as.formula("~GDD+FDD+forest"), sample = 1000)  
plot(m)
}
\author{
Giovanni Poggiato
}
