% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sigma.R
\name{get_sigma}
\alias{get_sigma}
\title{Get the inferred residual covariance matrix}
\usage{
get_sigma(m)
}
\arguments{
\item{m}{a model fitted with \code{jtdm_fit}}
}
\value{
A list containing:
   \item{Ssamples}{ Sample from the posterior distribution of the residual covariance matrix. It is an array where the first two dimensions are the rows and columns of the matrix, and the third dimensions are the samples from the posterior distribution}
  
   \item{Smean}{ Posterior mean of the residual covariance matrix.}
  
   \item{Sq975,Sq025}{ 97.5\% and 0.25\% posterior quantiles of the residual covariance matrix.}
}
\description{
Get the samples from the posterior distribution of the residual covariance matrix, together with the posterior mean and quantiles.
}
\examples{
data(Y)  
data(X) 
# Short MCMC to obtain a fast example: results are unreliable !
m = jtdm_fit(Y=Y, X=X, formula=as.formula("~GDD+FDD+forest"), sample = 1000) 
# get the inferred residual covariance
Sigma =get_sigma(m)
}
