% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jable.R
\name{md_table}
\alias{md_table}
\title{Print attractive data frames in the console}
\usage{
md_table(x, format = "markdown", digits = getOption("jtools-digits",
  2), sig.digits = TRUE, row.names = NA, col.names = NA,
  format.args = list(), align = NULL)
}
\arguments{
\item{x}{A data frame or matrix.}

\item{format}{The style, which can be either "markdown" or "pandoc".
Default: "markdown"}

\item{digits}{How many digits to print for numbers.
Default: 2}

\item{sig.digits}{Should each number be printed with \code{digits} number of
digits or only when there are at least that many significant digits? Default
is TRUE, meaning only print \code{digits} number of \emph{significant} digits.}

\item{row.names}{Logical: whether to include row names. By
default, row names are included if \code{rownames(x)} is neither
\code{NULL} nor identical to \code{1:nrow(x)}.}

\item{col.names}{A character vector of column names to be used in the table.}

\item{format.args}{A list of arguments to be passed to \code{\link{format}()}
to format table values, e.g. \code{list(big.mark = ',')}.}

\item{align}{Column alignment: a character vector consisting of ‘'l'’
(left), ‘'c'’ (center) and/or ‘'r'’ (right). By default or if
‘align = NULL’, numeric columns are right-aligned, and other
columns are left-aligned.}
}
\description{
This function takes data frame input and prints to the console
as a markdown table for better readability.
}
